--FullCombo base from moonlight by AJ

local pn = ...;
assert(pn);

local t = Def.ActorFrame{};

local IsUsingSoloSingles = PREFSMAN:GetPreference('Center1Player');
local NumPlayers = GAMESTATE:GetNumPlayersEnabled();
local NumSides = GAMESTATE:GetNumSidesJoined();

local pStats = STATSMAN:GetCurStageStats():GetPlayerStageStats(pn);

local function GetPosition(pn)
	if IsUsingSoloSingles and NumPlayers == 1 and NumSides == 1 then return SCREEN_CENTER_X; end;
	
	local strPlayer = (NumPlayers == 1) and "OnePlayer" or "TwoPlayers";
	local strSide = (NumSides == 1) and "OneSide" or "TwoSides";

	return THEME:GetMetric("ScreenGameplay","Player".. ToEnumShortString(pn) .. strPlayer .. strSide .."X");

end;

--Marvelous FullCombo
t[#t+1] = LoadActor("Text_MarvelousFullCombo")..{
	InitCommand=cmd(diffusealpha,0;x,GetPosition(pn);y,SCREEN_CENTER_Y);	
	OffCommand=function(self)
		local fct = STATSMAN:GetCurStageStats():GetPlayerStageStats(pn);
		if fct:FullComboOfScore('TapNoteScore_W1') == true then
				self:zoom(1);
				self:rotationz(45);
				self:diffusealpha(0);
				self:smooth(0.6);
				self:zoom(0.8);
				self:diffusealpha(1);
				self:rotationz(0);
				self:sleep(0.4);
				self:smooth(0.4);
				self:diffusealpha(0);
				self:zoom(2);
				self:rotationz(-10);
		elseif fct:FullComboOfScore('TapNoteScore_W2') == true then
			self:visible(false);
		elseif fct:FullComboOfScore('TapNoteScore_W3') == true then
			self:visible(false);
		else
			self:visible(false);
		end;
	end;	
};

--Perfect FullCombo
t[#t+1] = LoadActor("Text_PerfectFullCombo")..{
	InitCommand=cmd(diffusealpha,0;x,GetPosition(pn);y,SCREEN_CENTER_Y);	
	OffCommand=function(self)
		local fct = STATSMAN:GetCurStageStats():GetPlayerStageStats(pn);
		if fct:FullComboOfScore('TapNoteScore_W1') == true then
			self:visible(false);
		elseif fct:FullComboOfScore('TapNoteScore_W2') == true then
				self:zoom(1);
				self:rotationz(45);
				self:diffusealpha(0);
				self:smooth(0.6);
				self:zoom(0.8);
				self:diffusealpha(1);
				self:rotationz(0);
				self:sleep(0.4);
				self:smooth(0.4);
				self:diffusealpha(0);
				self:zoom(2);
				self:rotationz(-10);
		elseif fct:FullComboOfScore('TapNoteScore_W3') == true then
			self:visible(false);
		else
			self:visible(false);
		end;
	end;	
};

--FullCombo
t[#t+1] = LoadActor("Text_FullCombo")..{
	InitCommand=cmd(diffusealpha,0;x,GetPosition(pn);y,SCREEN_CENTER_Y);	
	OffCommand=function(self)
		local fct = STATSMAN:GetCurStageStats():GetPlayerStageStats(pn);
		if fct:FullComboOfScore('TapNoteScore_W1') == true then
			self:visible(false);
		elseif fct:FullComboOfScore('TapNoteScore_W2') == true then
			self:visible(false);
		elseif fct:FullComboOfScore('TapNoteScore_W3') == true then
				self:zoom(1);
				self:rotationz(45);
				self:diffusealpha(0);
				self:smooth(0.6);
				self:zoom(0.8);
				self:diffusealpha(1);
				self:rotationz(0);
				self:sleep(0.4);
				self:smooth(0.4);
				self:diffusealpha(0);
				self:zoom(2);
				self:rotationz(-10);
		else
			self:visible(false);
		end;
	end;	
};

t[#t+1] = LoadActor("_keybox") .. {
		InitCommand=function(self)
			self:diffusealpha(0);
			self:x( GetPosition(pn) );
			self:y(SCREEN_CENTER_Y);
		end;	
		OffCommand=function(self)		
			if pStats:FullCombo() then
				self:zoom(0.3);
				self:rotationz(-45);
				self:diffusealpha(0);
				self:smooth(0.1);
				self:diffusealpha(1);
				self:smooth(0.6)
				self:diffusealpha(0);
				self:zoom(0.5);
			end;
		end;	
	};

return t;